<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Media;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class MediaController extends Controller
{
    public function index()
    {
        $media = Media::latest()->paginate(40);
        return view('admin.media.index', compact('media'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'file' => 'required|file|max:5120',
        ]);

        $file = $request->file('file');
        $path = $file->store('uploads', 'public');

        Media::create([
            'file_name'     => basename($path),
            'original_name' => $file->getClientOriginalName(),
            'mime_type'     => $file->getClientMimeType(),
            'size'          => $file->getSize(),
            'disk'          => 'public',
            'path'          => $path,
            'alt_text'      => '',
            'created_by'    => auth()->id(),
        ]);

        return back()->with('success','تم رفع الملف بنجاح');
    }

    public function destroy(Media $media)
    {
        Storage::disk($media->disk)->delete($media->path);
        $media->delete();
        return back()->with('success','تم حذف الملف بنجاح');
    }
}
