<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Menu;
use App\Models\MenuItem;
use Illuminate\Http\Request;

class MenuController extends Controller
{
    public function index()
    {
        $menus = Menu::all();
        return view('admin.menus.index', compact('menus'));
    }

    public function create()
    {
        return view('admin.menus.create');
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'name' => 'required|string|max:255',
            'location' => 'required|string|max:100',
        ]);

        Menu::create($data);
        return redirect()->route('menus.index')->with('success','تم إنشاء القائمة بنجاح');
    }

    public function edit(Menu $menu)
    {
        $items = $menu->items()->with('children')->get();
        return view('admin.menus.edit', compact('menu','items'));
    }

    public function update(Request $request, Menu $menu)
    {
        $data = $request->validate([
            'name' => 'required|string|max:255',
            'location' => 'required|string|max:100',
        ]);

        $menu->update($data);
        return redirect()->route('menus.index')->with('success','تم تحديث القائمة بنجاح');
    }

    public function destroy(Menu $menu)
    {
        $menu->items()->delete();
        $menu->delete();
        return redirect()->route('menus.index')->with('success','تم حذف القائمة بنجاح');
    }
}
