<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Page;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class PageController extends Controller
{
    public function index()
    {
        $pages = Page::latest()->paginate(20);
        return view('admin.pages.index', compact('pages'));
    }

    public function create()
    {
        $page = new Page();
        return view('admin.pages.create', compact('page'));
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'title'  => 'required|string|max:255',
            'slug'   => 'nullable|string|max:255|unique:pages,slug',
            'body'   => 'required|string',
            'status' => 'required|in:draft,published',
            'meta_title' => 'nullable|string|max:255',
            'meta_description' => 'nullable|string|max:300',
        ]);

        $data['slug'] = $data['slug'] ?: Str::slug($data['title']).'-'.time();

        Page::create($data);

        return redirect()->route('pages.index')->with('success','تم إنشاء الصفحة بنجاح');
    }

    public function edit(Page $page)
    {
        return view('admin.pages.edit', compact('page'));
    }

    public function update(Request $request, Page $page)
    {
        $data = $request->validate([
            'title'  => 'required|string|max:255',
            'slug'   => 'nullable|string|max:255|unique:pages,slug,'.$page->id,
            'body'   => 'required|string',
            'status' => 'required|in:draft,published',
            'meta_title' => 'nullable|string|max:255',
            'meta_description' => 'nullable|string|max:300',
        ]);

        $data['slug'] = $data['slug'] ?: $page->slug;

        $page->update($data);

        return redirect()->route('pages.index')->with('success','تم تحديث الصفحة بنجاح');
    }

    public function destroy(Page $page)
    {
        $page->delete();
        return redirect()->route('pages.index')->with('success','تم حذف الصفحة بنجاح');
    }
}
