<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Media extends Model
{
    protected $fillable = [
        'file_name','original_name','mime_type','size',
        'disk','path','alt_text','created_by'
    ];

    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function getUrlAttribute()
    {
        return \Storage::disk($this->disk)->url($this->path);
    }
}
