@csrf
<div class="mb-3">
    <label class="form-label">العنوان</label>
    <input type="text" name="title" class="form-control" value="{{ old('title', $article->title ?? '') }}" required>
</div>

<div class="mb-3">
    <label class="form-label">التصنيف</label>
    <select name="category_id" class="form-select">
        <option value="">بدون</option>
        @foreach($categories as $cat)
            <option value="{{ $cat->id }}" @selected(old('category_id', $article->category_id ?? null) == $cat->id)>
                {{ $cat->name }}
            </option>
        @endforeach
    </select>
</div>

<div class="mb-3">
    <label class="form-label">مقتطف (اختياري)</label>
    <textarea name="excerpt" class="form-control" rows="2">{{ old('excerpt', $article->excerpt ?? '') }}</textarea>
</div>

<div class="mb-3">
    <label class="form-label">المحتوى</label>
    <textarea name="body" class="form-control" rows="8" required>{{ old('body', $article->body ?? '') }}</textarea>
</div>

<div class="mb-3">
    <label class="form-label">الحالة</label>
    <select name="status" class="form-select" required>
        <option value="draft" @selected(old('status', $article->status ?? 'draft') === 'draft')>مسودة</option>
        <option value="published" @selected(old('status', $article->status ?? 'draft') === 'published')>منشور</option>
    </select>
</div>

<div class="mb-3">
    <label class="form-label">Meta Title</label>
    <input type="text" name="meta_title" class="form-control" value="{{ old('meta_title', $article->meta_title ?? '') }}">
</div>

<div class="mb-3">
    <label class="form-label">Meta Description</label>
    <textarea name="meta_description" class="form-control" rows="2">{{ old('meta_description', $article->meta_description ?? '') }}</textarea>
</div>

<button class="btn btn-primary">حفظ</button>
