@extends('layouts.admin')

@section('title','المقالات')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-3">
    <h1 class="h4 mb-0">المقالات</h1>
    <a href="{{ route('articles.create') }}" class="btn btn-primary btn-sm">إضافة مقال جديد</a>
</div>

<table class="table table-sm align-middle">
    <thead>
        <tr>
            <th>العنوان</th>
            <th>التصنيف</th>
            <th>الحالة</th>
            <th>تاريخ النشر</th>
            <th></th>
        </tr>
    </thead>
    <tbody>
        @forelse($articles as $article)
            <tr>
                <td>{{ $article->title }}</td>
                <td>{{ $article->category->name ?? '-' }}</td>
                <td>{{ $article->status === 'published' ? 'منشور' : 'مسودة' }}</td>
                <td>{{ optional($article->published_at)->format('Y-m-d') }}</td>
                <td class="text-end">
                    <a href="{{ route('articles.edit', $article) }}" class="btn btn-sm btn-outline-secondary">تعديل</a>
                    <form action="{{ route('articles.destroy', $article) }}" method="POST" class="d-inline">
                        @csrf
                        @method('DELETE')
                        <button class="btn btn-sm btn-outline-danger" onclick="return confirm('تأكيد الحذف؟')">حذف</button>
                    </form>
                </td>
            </tr>
        @empty
            <tr><td colspan="5" class="text-center text-muted">لا توجد مقالات</td></tr>
        @endforelse
    </tbody>
</table>

{{ $articles->links() }}
@endsection
