@extends('layouts.app')

@section('title','المقالات')

@section('content')
<h1 class="h3 mb-4">كل المقالات</h1>

@foreach($articles as $article)
    <article class="mb-4 border-bottom pb-3">
        <h2 class="h5">
            <a href="{{ route('articles.show', $article->slug) }}" class="text-decoration-none">
                {{ $article->title }}
            </a>
        </h2>
        <p class="small text-muted">
            {{ optional($article->published_at)->format('Y-m-d') }}
        </p>
        <p>{{ Str::limit($article->excerpt ?: strip_tags($article->body), 150) }}</p>
    </article>
@endforeach

{{ $articles->links() }}
@endsection
