@extends('layouts.app')

@section('title', $article->title)
@section('meta_description', $article->meta_description)

@section('content')
<article>
    <h1 class="h3 mb-3">{{ $article->title }}</h1>
    <p class="small text-muted mb-4">
        {{ optional($article->published_at)->format('Y-m-d') }}
        @if($article->category)
            • في {{ $article->category->name }}
        @endif
    </p>
    <div class="content">
        {!! $article->body !!}
    </div>
</article>
@endsection
