@extends('layouts.app')

@section('title','الرئيسية')

@section('content')
<div class="row mb-4">
    <div class="col-12">
        <h1 class="h3 mb-3">مرحباً بك في نظام إدارة المحتوى</h1>
        <p class="text-muted">هذه الصفحة الرئيسية تعرض أحدث المقالات المنشورة.</p>
    </div>
</div>

<div class="row">
    @forelse($articles as $article)
        <div class="col-md-4 mb-3">
            <div class="card h-100">
                <div class="card-body">
                    <h2 class="h5">
                        <a href="{{ route('articles.show', $article->slug) }}" class="text-decoration-none">
                            {{ $article->title }}
                        </a>
                    </h2>
                    <p class="small text-muted mb-2">
                        {{ optional($article->published_at)->format('Y-m-d') }}
                    </p>
                    <p class="mb-0">{{ Str::limit($article->excerpt ?: strip_tags($article->body), 100) }}</p>
                </div>
            </div>
        </div>
    @empty
        <p class="text-muted">لا توجد مقالات منشورة حالياً.</p>
    @endforelse
</div>
@endsection
