<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="utf-8">
    <title>@yield('title', config('app.name'))</title>
    <meta name="description" content="@yield('meta_description', 'وصف افتراضي للموقع')">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link href="{{ asset('css/bootstrap.min.css') }}" rel="stylesheet">
    <style>
        body { font-family: system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif; }
        .navbar-brand { font-weight: 700; }
    </style>
</head>
<body>

@include('front.partials.nav')

<main class="py-4">
    <div class="container">
        @yield('content')
    </div>
</main>

<footer class="border-top py-3 mt-5">
    <div class="container text-center text-muted">
        &copy; {{ date('Y') }} - {{ \App\Models\Setting::get('site_name', config('app.name')) }}
    </div>
</footer>

<script src="{{ asset('js/bootstrap.bundle.min.js') }}"></script>
@stack('scripts')
</body>
</html>
