<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Front\HomeController;
use App\Http\Controllers\Front\ArticleController as FrontArticleController;
use App\Http\Controllers\Front\PageController as FrontPageController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\ArticleController;
use App\Http\Controllers\Admin\CategoryController;
use App\Http\Controllers\Admin\PageController;
use App\Http\Controllers\Admin\MediaController;
use App\Http\Controllers\Admin\MenuController;
use App\Http\Controllers\Admin\SettingController;

Route::get('/', [HomeController::class, 'index'])->name('home');

Route::get('/articles', [FrontArticleController::class, 'index'])->name('articles.index');
Route::get('/articles/{slug}', [FrontArticleController::class, 'show'])->name('articles.show');
Route::get('/page/{slug}', [FrontPageController::class, 'show'])->name('pages.show');

// Auth routes (تأكد من تفعيل حزمة المصادقة المناسبة مثل Laravel Breeze)
Auth::routes();

// لوحة التحكم
Route::prefix('admin')->middleware(['auth', 'admin'])->group(function () {
    Route::get('/', [DashboardController::class, 'index'])->name('admin.dashboard');

    Route::resource('articles', ArticleController::class);
    Route::resource('categories', CategoryController::class);
    Route::resource('pages', PageController::class);
    Route::resource('media', MediaController::class)->only(['index','store','destroy']);
    Route::resource('menus', MenuController::class);

    Route::get('settings', [SettingController::class, 'index'])->name('settings.index');
    Route::post('settings', [SettingController::class, 'update'])->name('settings.update');
});
